require_relative "./run.rb"

if i=ARGV.index("--")
  $raw_args = ARGV[i+1..-1]
  ARGV[i..-1] = []
end

if ["-v", "--version"].any?{|option| ARGV.delete(option) }
  puts Version
  exit
end

pretty_print = ["-pp", "--pretty_print"].any?{|option| ARGV.delete(option) }
hs = ["-hs", "--hs"].any?{|option| ARGV.delete(option) }

begin
  raise IogiiError.new "usage: ruby #$0 -v,--version | [-p,--pretty_print] [-hs,--hs] <filename.iog> [-- rawargs*]" if ARGV.size == 0 || ARGV.any?{|a| a[0] == "-" }
  raise IogiiError.new "mustn't give more than one file arg" if ARGV.size > 1
  if ARGV.size == 1
    raise IogiiError.new "file does not exist: %p" % ARGV[0] if !File.file?(ARGV[0])
    input = IO.binread(ARGV[0])
  end
  run_and_do_io(input, pretty_print, hs)
rescue IogiiError => e
  STDERR.puts e.message
rescue => e
  STDERR.puts "This is an internal iogii error, please report it!\n".red
  raise e
end
