require_relative "./lazylib.rb"

def make_promises(ir, ranks, types)
  promises = ir.map.with_index{|node,i|
    arg_types = node.args.map{|a|types[a]}
    arg_ranks = node.args.map{|a|ranks[a]}
    way = find_valid_way(ir[i], arg_types, arg_ranks)

    coerces = coerce?(way.arg_types,arg_types)
    zip_level = zip_level(way, arg_ranks, arg_types)
    excess = excess_ranks(way, arg_ranks, arg_types)

    impl = lambda{|*args|
      $rank = way.vectorize ? way.mod : ranks[ir[i].args[0]]
      $at = coerces[0] ? CharType : arg_types[0]
      $bt = coerces[1] ? CharType : arg_types[1]
      way.impl[*args]
    }

    promise{
      args = node.args.map{|a| promises[a] }
      args = args.zip(coerces,arg_ranks).map{|a,c,r|
        c ? promise{ zipn(r, [a], ->aa{ str(aa) }) } : a }
      special_rep = way.promote.include?(RepSnd) && excess[1] < 0
      args = args.zip(excess,0..).map{|a,e,ind| promoten(-e - (special_rep && ind==1 ? 1 : 0), a) }
      new_excess = excess.map{|e| e = [e, 0].max }
      args = args.zip(new_excess,0..).map{|a,e,ind| repn(zip_level - e + (special_rep && ind==1 ? 1 : 0), a)}
      if node.op.name == "superpad"
        superpad(zip_level, args[0])
      else
        zipn(zip_level, args, impl)
      end
    }
  }
  promises
end
