require_relative "./lex.rb"
require_relative "./error.rb"
require_relative "./parse.rb"
require_relative "./ir.rb"
require_relative "./infer.rb"
require_relative "./promise.rb"
require_relative "./version.rb"

NittyGritty = "https://golfscript.com/iogii/nittygritty.html"

def run(source, arg)
  tokens = lex(source)
  ast, ast_inds, registers, preprints=*parse_main(tokens)
  ir, ast2ir = *to_ir(ast, arg, registers)
  types=solve_types(ir)
  ranks=solve_ranks(ir, types)
  promises=make_promises(ir, ranks, types)
  stack_inds = ast_inds.map{|i| ast2ir[i] }
  preprint_inds = preprints.map{|i| ast2ir[i] }
  return [ir, stack_inds, types, ranks, promises, preprint_inds]
end

def run_and_do_io(source)
  ir, ir_inds, types, ranks, promises, preprint_inds = run(source, new_op("stdinLines", "[[char]]"){ lines(ReadStdin) })
  begin
    preprint_inds.each{|ir_ind|
      printv(promises[ir_ind].value, types[ir_ind], ranks[ir_ind])
      puts
    }

    ir_inds.each{|ir_ind|
      printv(promises[ir_ind].value, types[ir_ind], ranks[ir_ind])
    }
  rescue SystemStackError => e
    raise IogiiError.new "Stack Overflow"
  end
end
