require_relative "./lex.rb"
require_relative "./lazylib.rb"

SepRx = /, | |,/
NumRx = /-?\d+/
BetweenRx = /#{SepRx}|#{NewlineRx}|#{SepRx}#{NewlineRx}/

def parse_input
  input = to_eager_str($ReadStdin.value)

  lazy_input = lines($ReadStdin)
  # is it just numbers?
  if input =~ /\A#{NumRx}(#{BetweenRx}#{NumRx})*#{BetweenRx}?\Z/m
    read = map(lazy_input.const){|v|split_non_digits(v)}
    eager = to_eager_list(read.const).map{|a| to_eager_list(a.const) }

    if eager.size == 1 && eager[0].size == 1 # is it 1 number
      [eager[0][0], IntType, 0]
    elsif eager.size == 1 # is it a row
      [read[0].value, IntType, 1]
    elsif eager.all?{|a|a.size == 1} # is it a col
      [map(read.const){|v|v.value[0].value}, IntType, 1]
    else # its a matrix
      [read, IntType, 2]
    end
  else # not numbers
    if input =~ /#{NewlineRx}./m # multi line
      [lazy_input, CharType, 2]
    else
      [lazy_input.empty? ? [] : lazy_input[0].value, CharType, 1, lazy_input.empty?]
    end
  end
end