require "./web/examples.rb"
require "./lazylib.rb"
require "./run.rb"

def output(str)
  $output << str
end

Examples.each{|name, prog, input, expected|
  $ReadStdin = Promise.new{ str_to_lazy_list(input) }
  begin
    $output = ""
    run_and_do_io(prog)

    if $output != expected
      STDERR.puts "FAIL: #{name}"
      STDERR.puts prog
      STDERR.puts "expected:"
      STDERR.puts expected
      STDERR.puts "found:"
      STDERR.puts $output
    end
  rescue => e
    STDERR.puts "error in "+name
    raise e
  end
}

puts "PASS #{Examples.size} examples"
