require "./ops.rb"

def collect_tests
  start_line = 0
  tests = File.read("test/tests.txt").lines.map{|line|
    start_line += 1
    next if line.strip == "" || line =~ /^\#/
    prog, expected=line.split("-"+">")
    expected.gsub!('\n', "\n")
    [prog, expected, "test.txt, line #{start_line}"]
  }.compact

  Dir["docs/*"].each{|file|
    File.read(file).lines.each.with_index{|line,line_no|
      if line =~ /^(.*)->(.*)/
        where = "#{file}, line #{line_no+1}"
        raise "need to indent code at #{where}" if $1[0,4]!=" "*4
        tests << [$1, $2, where]
      end
    }
  }

  OpExamples.each{|names,example|
    if example =~ /^(.*)->(.*)/
      tests << [$1, $2, "op example: %s" % names]
    end
  }

  tests
end