require "./run.rb"
require "./test/collect_tests.rb"
require 'stringio'

Arg = new_op("data", "int"){ 777 }

def runtest(prog, len=1000)
  ast, ast_out_inds, registers, ir2, ir2_inds, ir3, ir3_ind = run(prog, Arg, " ")
  promises = make_promises(ir3)
  to_eager_str(take(len,promises[ir3_ind]))
end

tests = collect_tests

pass = 0
tests.each{|test|
  $stderr = StringIO.new

  prog, expected, from = *test
  expected = "" if !expected
  expected.strip!
  prog.strip!
  begin
    found = ""
    if expected =~ /\.\.\.$/
      found = runtest(prog, $`.size)
      expected = $`
    elsif expected =~ /\.\.\./
      found = runtest(prog)
      found = found[0,$`.size]+"..."+found[-$'.size..-1]
    else
      found = runtest(prog)
    end
    found.rstrip!
    errored = false
  rescue Exception
    errored = $!
    found << $!.message.gsub(IogiiError.new("").message, "")
  end
  found += "\n"+$stderr.string if expected != "Overflow" # don't add it for this because ruby makes a weird warning
  found.chomp!
  expected.gsub!("WARNING: ","WARNING: ".red)

  if expected == "RANK ERROR" && found[/arg \d rank too low/]
  elsif found != expected
    STDERR.puts "FAIL: #{from}"
    STDERR.puts prog
    STDERR.puts "expected:"
    STDERR.puts expected
    STDERR.puts "found:"
    STDERR.puts found
    $stderr = STDERR
    raise errored if errored
    exit(1)
  end

  pass += 1
}

puts "PASS #{pass} tests"
