Encoding.default_external="iso-8859-1"
Encoding.default_internal="iso-8859-1"

require_relative "./run.rb"
require_relative "./graphviz.rb"
require "js"

class Promise
  alias orig_value value
  def value
    if Time.now - $start_time > 2.0
      error_output "timeout" # todo, do this from JS?
      exit
    end
    orig_value
  end
end

runbutton = JS.global[:document].getElementById("runbutton")
hsbutton = JS.global[:document].getElementById("hsbutton")
Program = JS.global[:document].getElementById("program")
Prettyprintbox = JS.global[:document].getElementById("prettyprintbox")
WEB_OUTPUT = JS.global[:document].getElementById("output")
WEB_STDERR = JS.global[:document].getElementById("stderr")
WEB_INPUT = JS.global[:document].getElementById("input")

def append_js(output_str, var, str)
  output_str << str
  begin
    var[:value] = output_str.dup.force_encoding("utf-8").to_js
  rescue Encoding::CompatibilityError
    var[:value] = output_str.to_js
  end
end

def output(str)
  append_js($ruby_output, WEB_OUTPUT, str)
end

def error_output(str)
  append_js($ruby_stderr, WEB_STDERR, str)
end

class String
  def red
    self
  end
end

WEB_OUTPUT[:value] = "ready"

def render_graphviz(graph, component)
  JS.eval('d3.select("#' + component + '").graphviz().renderDot('+graph.inspect+');')
end

def doit(hs)
  $ruby_output = ""
  $ruby_stderr = ""

  output(""); error_output("") # reset displays
  $ReadStdinLines = Promise.new{ lines(Promise.new{ to_lazy_list(WEB_INPUT[:value].to_s.bytes.to_a) }) }
  pretty_print = Prettyprintbox[:checked].to_s == "true"
  prog = Program[:value].to_s.bytes.map(&:chr).join

  $start_time = Time.now
  begin
    ast,ast_out_inds,registers,ir2,ir2_out_inds = *run_and_do_io(prog, pretty_print, hs)

    if !hs
      ast_graph = ast2viz(ast, ast_out_inds, registers)
      render_graphviz(ast_graph, "ast_graph")

      ir_graph = ir2viz(ir2, ir2_out_inds)
      render_graphviz(ir_graph, "ir_graph")
    end
  rescue IogiiError => e
    error_output e.message + "\n"
  rescue => e
    error_output "This is an internal iogii error, please report it!\n".red + "\n"
    raise e
  end
end

run_cb = -> event {
  doit(false)
}

hs_cb = -> event {
  doit(true)
}

runbutton.call(:addEventListener, "click", &run_cb)
hsbutton.call(:addEventListener, "click", &hs_cb)
JS.global[:window].call(:addEventListener, 'popstate', &run_cb)

run_cb[nil]