require "./ops.rb"

def collect_tests
  start_line = 0
  tests = IO.binread("test/tests.txt").lines.map{|line|
    start_line += 1
    location = "tests.txt, line #{start_line}"
    next if line.strip == "" || line =~ /^\# /
    prog, expected=line.split("->")
    raise "invalid test format at %s" % location if !expected
    expected.gsub!('\n', "\n")
    [prog.strip, expected.strip, location,"777"]
  }.compact

  Dir["docs/*"].each{|file|
    IO.binread(file).lines.each.with_index{|line,line_no|
      if line =~ /^(.*)->(.*)/
        where = "#{file}, line #{line_no+1}"
        raise "need to indent code at #{where}" if $1[0,4]!=" "*4
        tests << [$1.strip, $2.strip, where]
      end
    }
  }

  def clean(s)
    s.gsub(/^ */,'').strip
  end

  Dir["docs/*"].each{|file|
    IO.binread(file).scan(/(^( [^\n]*\n)|\n)+/m){
      example = $&
      next unless example['---']
      where = "#{file}, line #{$`.count("\n")+2}"
      example =~ /^(.*?)---(.*)$/m
      fst,rest = $1,$2
      if $2 =~ /^(.*?)---(.*)$/m
        tests << [clean($1), clean($2), where, clean(fst), true]
      else
        tests << [clean(fst), clean(rest), where, "", true]
      end
    }
  }

  OpExamples.each{|names,example|
    if example =~ /^(.*)->(.*)/
      tests << [$1.strip, $2.strip, "op example: %s" % names]
    end
  }

  tests
end